<?php

namespace App\Models {

	/**
	 * App\Models\BaseModel
	 *
	 * @property-read mixed $status_label
	 * @property-read mixed $status_label_text
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \Spatie\MediaLibrary\MediaCollections\Models\Media> $media
	 * @property-read int|null $media_count
	 * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, $uniqueBy, $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class BaseModel extends \Illuminate\Database\Eloquent\Model
	{
		//
	}

	/**
	 * App\Models\Device
	 *
	 * @property string|null $deleted_at
	 * @property \Illuminate\Support\Carbon|null $updated_at
	 * @property \Illuminate\Support\Carbon|null $created_at
	 * @property string|null $platform
	 * @property string|null $active_profile
	 * @property string|null $device_name
	 * @property string|null $device_id
	 * @property integer|null $user_id
	 * @property int $id
	 * @method static \Illuminate\Database\Eloquent\Builder<Device>|Device whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Device>|Device whereUserId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Device>|Device whereDeviceId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Device>|Device whereDeviceName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Device>|Device whereActiveProfile($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Device>|Device wherePlatform($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Device>|Device whereCreatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Device>|Device whereUpdatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Device>|Device whereDeletedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Device>|Device newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Device>|Device newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Device>|Device query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, $uniqueBy, $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class Device extends \Illuminate\Database\Eloquent\Model
	{
		//
	}

	/**
	 * App\Models\Languages
	 *
	 * @property \Illuminate\Support\Carbon|null $deleted_at
	 * @property \Illuminate\Support\Carbon|null $updated_at
	 * @property \Illuminate\Support\Carbon|null $created_at
	 * @property int|null $deleted_by
	 * @property int|null $updated_by
	 * @property int|null $created_by
	 * @property string $file
	 * @property string $language
	 * @property string $value
	 * @property string $key
	 * @property int $id
	 * @property-read mixed $status_label
	 * @property-read mixed $status_label_text
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \Spatie\MediaLibrary\MediaCollections\Models\Media> $media
	 * @property-read int|null $media_count
	 * @method static \Illuminate\Database\Eloquent\Builder<Languages>|Languages whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Languages>|Languages whereKey($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Languages>|Languages whereValue($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Languages>|Languages whereLanguage($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Languages>|Languages whereFile($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Languages>|Languages whereCreatedBy($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Languages>|Languages whereUpdatedBy($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Languages>|Languages whereDeletedBy($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Languages>|Languages whereCreatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Languages>|Languages whereUpdatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Languages>|Languages whereDeletedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Languages>|Languages newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Languages>|Languages newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Languages>|Languages query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, $uniqueBy, $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class Languages extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\MobileSetting
	 *
	 * @property \Illuminate\Support\Carbon|null $deleted_at
	 * @property \Illuminate\Support\Carbon|null $updated_at
	 * @property \Illuminate\Support\Carbon|null $created_at
	 * @property string|null $value
	 * @property int|null $position
	 * @property string|null $slug
	 * @property string|null $name
	 * @property int $id
	 * @method static \Illuminate\Database\Eloquent\Builder<MobileSetting>|MobileSetting whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<MobileSetting>|MobileSetting whereName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<MobileSetting>|MobileSetting whereSlug($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<MobileSetting>|MobileSetting wherePosition($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<MobileSetting>|MobileSetting whereValue($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<MobileSetting>|MobileSetting whereCreatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<MobileSetting>|MobileSetting whereUpdatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<MobileSetting>|MobileSetting whereDeletedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<MobileSetting>|MobileSetting newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<MobileSetting>|MobileSetting newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<MobileSetting>|MobileSetting query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, $uniqueBy, $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class MobileSetting extends \Illuminate\Database\Eloquent\Model
	{
		//
	}

	/**
	 * App\Models\Modules
	 *
	 * @property bool $is_custom_permission
	 * @property \Illuminate\Support\Carbon|null $updated_at
	 * @property \Illuminate\Support\Carbon|null $created_at
	 * @property \Illuminate\Support\Carbon|null $deleted_at
	 * @property bool $status
	 * @property array|null $more_permission
	 * @property string|null $description
	 * @property string|null $module_name
	 * @property int $id
	 * @method static \Illuminate\Database\Eloquent\Builder<Modules>|Modules whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Modules>|Modules whereModuleName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Modules>|Modules whereDescription($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Modules>|Modules whereMorePermission($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Modules>|Modules whereStatus($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Modules>|Modules whereDeletedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Modules>|Modules whereCreatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Modules>|Modules whereUpdatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Modules>|Modules whereIsCustomPermission($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Modules>|Modules newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Modules>|Modules newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Modules>|Modules query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, $uniqueBy, $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class Modules extends \Illuminate\Database\Eloquent\Model
	{
		//
	}

	/**
	 * App\Models\Notification
	 *
	 * @property \Illuminate\Support\Carbon|null $updated_at
	 * @property \Illuminate\Support\Carbon|null $created_at
	 * @property string|null $read_at
	 * @property string $data
	 * @property int $notifiable_id
	 * @property string $notifiable_type
	 * @property string $type
	 * @property int $id
	 * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereType($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereNotifiableType($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereNotifiableId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereData($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereReadAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereCreatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereUpdatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, $uniqueBy, $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class Notification extends \Illuminate\Database\Eloquent\Model
	{
		//
	}

	/**
	 * App\Models\Permission
	 *
	 * @property \Illuminate\Support\Carbon|null $updated_at
	 * @property \Illuminate\Support\Carbon|null $created_at
	 * @property bool $is_fixed
	 * @property string $guard_name
	 * @property int $id
	 * @property-read mixed $name
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \Spatie\Permission\Models\Role> $roles
	 * @property-read int|null $roles_count
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\User> $users
	 * @property-read int|null $users_count
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \Spatie\Permission\Models\Permission> $permissions
	 * @property-read int|null $permissions_count
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission whereGuardName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission whereIsFixed($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission whereCreatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission whereUpdatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission role()
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission withoutRole()
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission permission()
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission withoutPermission()
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, $uniqueBy, $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class Permission extends \Spatie\Permission\Models\Permission
	{
		//
	}

	/**
	 * App\Models\Role
	 *
	 * @property \Illuminate\Support\Carbon|null $updated_at
	 * @property \Illuminate\Support\Carbon|null $created_at
	 * @property bool $is_fixed
	 * @property string $guard_name
	 * @property string $title
	 * @property int $id
	 * @property-read mixed $name
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \Spatie\Permission\Models\Permission> $permissions
	 * @property-read int|null $permissions_count
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\User> $users
	 * @property-read int|null $users_count
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role whereTitle($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role whereGuardName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role whereIsFixed($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role whereCreatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role whereUpdatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role permission()
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role withoutPermission()
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, $uniqueBy, $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class Role extends \Spatie\Permission\Models\Role
	{
		//
	}

	/**
	 * App\Models\Setting
	 *
	 * @property \Illuminate\Support\Carbon|null $deleted_at
	 * @property \Illuminate\Support\Carbon|null $updated_at
	 * @property \Illuminate\Support\Carbon|null $created_at
	 * @property int|null $deleted_by
	 * @property int|null $updated_by
	 * @property int|null $created_by
	 * @property string|null $datatype
	 * @property string $type
	 * @property string|null $val
	 * @property int $id
	 * @property-read mixed $name
	 * @property-read mixed $status_label
	 * @property-read mixed $status_label_text
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \Spatie\MediaLibrary\MediaCollections\Models\Media> $media
	 * @property-read int|null $media_count
	 * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereVal($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereType($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereDatatype($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereCreatedBy($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereUpdatedBy($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereDeletedBy($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereCreatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereUpdatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereDeletedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, $uniqueBy, $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class Setting extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\TvLoginSession
	 *
	 * @property \Illuminate\Support\Carbon|null $updated_at
	 * @property \Illuminate\Support\Carbon|null $created_at
	 * @property \Illuminate\Support\Carbon $expires_at
	 * @property \Illuminate\Support\Carbon|null $confirmed_at
	 * @property int|null $user_id
	 * @property string $session_id
	 * @property int $id
	 * @method static \Illuminate\Database\Eloquent\Builder<TvLoginSession>|TvLoginSession whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TvLoginSession>|TvLoginSession whereSessionId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TvLoginSession>|TvLoginSession whereUserId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TvLoginSession>|TvLoginSession whereConfirmedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TvLoginSession>|TvLoginSession whereExpiresAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TvLoginSession>|TvLoginSession whereCreatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TvLoginSession>|TvLoginSession whereUpdatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TvLoginSession>|TvLoginSession newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<TvLoginSession>|TvLoginSession newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<TvLoginSession>|TvLoginSession query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, $uniqueBy, $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class TvLoginSession extends \Illuminate\Database\Eloquent\Model
	{
		//
	}

	/**
	 * App\Models\UserMultiProfile
	 *
	 * @property \Illuminate\Support\Carbon|null $updated_at
	 * @property \Illuminate\Support\Carbon|null $created_at
	 * @property \Illuminate\Support\Carbon|null $deleted_at
	 * @property int|null $deleted_by
	 * @property int|null $updated_by
	 * @property int|null $created_by
	 * @property string|null $avatar
	 * @property int $user_id
	 * @property int $id
	 * @property-read mixed $name
	 * @property-read mixed $is_child_profile
	 * @property-read mixed $status_label
	 * @property-read mixed $status_label_text
	 * @property-read \App\Models\Device $activeprofile
	 * @property-read \App\Models\User $user
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \Spatie\MediaLibrary\MediaCollections\Models\Media> $media
	 * @property-read int|null $media_count
	 * @method static \Illuminate\Database\Eloquent\Builder<UserMultiProfile>|UserMultiProfile whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UserMultiProfile>|UserMultiProfile whereUserId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UserMultiProfile>|UserMultiProfile whereAvatar($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UserMultiProfile>|UserMultiProfile whereCreatedBy($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UserMultiProfile>|UserMultiProfile whereUpdatedBy($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UserMultiProfile>|UserMultiProfile whereDeletedBy($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UserMultiProfile>|UserMultiProfile whereDeletedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UserMultiProfile>|UserMultiProfile whereCreatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UserMultiProfile>|UserMultiProfile whereUpdatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UserMultiProfile>|UserMultiProfile newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<UserMultiProfile>|UserMultiProfile newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<UserMultiProfile>|UserMultiProfile query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, $uniqueBy, $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class UserMultiProfile extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\UserProvider
	 *
	 * @property \Illuminate\Support\Carbon|null $updated_at
	 * @property \Illuminate\Support\Carbon|null $created_at
	 * @property string|null $avatar
	 * @property string $provider_id
	 * @property string $provider
	 * @property int $user_id
	 * @property int $id
	 * @property-read \App\Models\User $user
	 * @method static \Illuminate\Database\Eloquent\Builder<UserProvider>|UserProvider whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UserProvider>|UserProvider whereUserId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UserProvider>|UserProvider whereProvider($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UserProvider>|UserProvider whereProviderId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UserProvider>|UserProvider whereAvatar($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UserProvider>|UserProvider whereCreatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UserProvider>|UserProvider whereUpdatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UserProvider>|UserProvider newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<UserProvider>|UserProvider newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<UserProvider>|UserProvider query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, $uniqueBy, $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class UserProvider extends \Illuminate\Database\Eloquent\Model
	{
		//
	}

	/**
	 * App\Models\UserSearchHistory
	 *
	 * @property \Illuminate\Support\Carbon|null $updated_at
	 * @property \Illuminate\Support\Carbon|null $created_at
	 * @property string|null $type
	 * @property int|null $search_id
	 * @property string|null $search_query
	 * @property int|null $profile_id
	 * @property int|null $user_id
	 * @property int $id
	 * @property-read \Modules\Entertainment\Models\Entertainment $entertainment
	 * @property-read \Modules\Episode\Models\Episode $episode
	 * @property-read \Modules\Video\Models\Video $video
	 * @property-read \Modules\CastCrew\Models\CastCrew $castcrew
	 * @method static \Illuminate\Database\Eloquent\Builder<UserSearchHistory>|UserSearchHistory whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UserSearchHistory>|UserSearchHistory whereUserId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UserSearchHistory>|UserSearchHistory whereProfileId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UserSearchHistory>|UserSearchHistory whereSearchQuery($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UserSearchHistory>|UserSearchHistory whereSearchId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UserSearchHistory>|UserSearchHistory whereType($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UserSearchHistory>|UserSearchHistory whereCreatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UserSearchHistory>|UserSearchHistory whereUpdatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UserSearchHistory>|UserSearchHistory newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<UserSearchHistory>|UserSearchHistory newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<UserSearchHistory>|UserSearchHistory query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, $uniqueBy, $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class UserSearchHistory extends \Illuminate\Database\Eloquent\Model
	{
		//
	}

	/**
	 * App\Models\UserWatchHistory
	 *
	 * @property \Illuminate\Support\Carbon|null $updated_at
	 * @property \Illuminate\Support\Carbon|null $created_at
	 * @property string|null $deleted_at
	 * @property int|null $deleted_by
	 * @property int|null $updated_by
	 * @property int|null $created_by
	 * @property string|null $entertainment_type
	 * @property int|null $profile_id
	 * @property int|null $user_id
	 * @property int|null $entertainment_id
	 * @property int $id
	 * @method static \Illuminate\Database\Eloquent\Builder<UserWatchHistory>|UserWatchHistory whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UserWatchHistory>|UserWatchHistory whereEntertainmentId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UserWatchHistory>|UserWatchHistory whereUserId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UserWatchHistory>|UserWatchHistory whereProfileId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UserWatchHistory>|UserWatchHistory whereEntertainmentType($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UserWatchHistory>|UserWatchHistory whereCreatedBy($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UserWatchHistory>|UserWatchHistory whereUpdatedBy($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UserWatchHistory>|UserWatchHistory whereDeletedBy($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UserWatchHistory>|UserWatchHistory whereDeletedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UserWatchHistory>|UserWatchHistory whereCreatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UserWatchHistory>|UserWatchHistory whereUpdatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UserWatchHistory>|UserWatchHistory newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<UserWatchHistory>|UserWatchHistory newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<UserWatchHistory>|UserWatchHistory query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, $uniqueBy, $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class UserWatchHistory extends \Illuminate\Database\Eloquent\Model
	{
		//
	}

}

namespace Spatie\Permission\Models {

	/**
	 * Spatie\Permission\Models\Permission
	 *
	 * @property \Illuminate\Support\Carbon|null $updated_at
	 * @property \Illuminate\Support\Carbon|null $created_at
	 * @property bool $is_fixed
	 * @property string $guard_name
	 * @property string $name
	 * @property int $id
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \Spatie\Permission\Models\Role> $roles
	 * @property-read int|null $roles_count
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\User> $users
	 * @property-read int|null $users_count
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \Spatie\Permission\Models\Permission> $permissions
	 * @property-read int|null $permissions_count
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission whereName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission whereGuardName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission whereIsFixed($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission whereCreatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission whereUpdatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission role()
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission withoutRole()
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission permission()
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission withoutPermission()
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, $uniqueBy, $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class Permission extends \Illuminate\Database\Eloquent\Model
	{
		//
	}

	/**
	 * Spatie\Permission\Models\Role
	 *
	 * @property \Illuminate\Support\Carbon|null $updated_at
	 * @property \Illuminate\Support\Carbon|null $created_at
	 * @property bool $is_fixed
	 * @property string $guard_name
	 * @property string $title
	 * @property string $name
	 * @property int $id
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \Spatie\Permission\Models\Permission> $permissions
	 * @property-read int|null $permissions_count
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\User> $users
	 * @property-read int|null $users_count
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role whereName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role whereTitle($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role whereGuardName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role whereIsFixed($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role whereCreatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role whereUpdatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role permission()
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role withoutPermission()
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, $uniqueBy, $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class Role extends \Illuminate\Database\Eloquent\Model
	{
		//
	}

}